/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.util.AddressRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class CpuRegisterPanel
extends JToolBar {
    private Cpu6502 _cpu;
    private Font _textFont = new Font("Monospaced", 0, 12);
    private JTextField _editProgramCounter;
    private JTextField _editAccu;
    private JTextField _editX;
    private JTextField _editY;
    private JTextField _editFlags;
    private JTextField _editStackPointer;
    private JTextField _editTicks;
    private JTextField _editCounter;
    private int _lastPc = -1;
    private int _lastAccu = -1;
    private int _lastX = -1;
    private int _lastY = -1;
    private int _lastFlags = -1;
    private int _lastSp = -1;
    private long _currentCounterOffset = 0L;
    private Color _defaultTextColor;
    private JButton _resetCounterButton;

    public CpuRegisterPanel(Cpu6502 cpu) {
        this._cpu = cpu;
        this.initPanel();
        this.updateValues(cpu.isRunning());
    }

    private void initPanel() {
        this._editProgramCounter = this.createBlock("PC", "$MMMM", "Program counter");
        this.addSeparator();
        this._editAccu = this.createBlock("AC", "$MM", "Accumulator");
        this._editX = this.createBlock("X", "$MM", "Index register X");
        this._editY = this.createBlock("Y", "$MM", "Index register Y");
        this.addSeparator();
        this._editFlags = this.createBlock("Flags", "MMMMMMMM", "<html><b>Processor flags.</b><br><br>In order to set flags, enter the corresponding letters in any order. Clear a flag, by deleting its letter.<br><br><b><i>Flags:</b></i><dl><dt><b>B</b>reak</dt><dd>Indicates that an interrupt was triggered by a BRK</dd><dt><b>C</b>arry</dt><dd>Last operation overflowed to carry</dd><dt><b>D</b>ecimal</dt><dd>Enables decimal mode if set</dd><dt><b>I</b>nterrupt</dt><dd>Disables interrupts if set</dd><dt><b>N</b>egative</dt><dd>Last arithmetic operation had a negative result</dd><dt>O<b>v</b>erflow</dt><dd>Last arithmetic operation had a signed overflow</dd><dt><b>Z</b>ero</dt><dd>Last operation result was zero</dd></dl></html>");
        this.addSeparator();
        this._editStackPointer = this.createBlock("SP", "$MM", "Stack pointer");
        this.addSeparator();
        this._editTicks = this.createBlock("Cycle", "88888888", "Current clock cycle");
        this._editTicks.setFocusable(false);
        JLabel label = new JLabel("Count");
        this._editCounter = new JTextField("88888888");
        this._editCounter.setFont(this._textFont);
        if ("Resettable cycle counter" != null) {
            this._editCounter.setToolTipText("Resettable cycle counter");
        }
        this._editCounter.setFocusable(false);
        this._resetCounterButton = new JButton();
        this._resetCounterButton.setToolTipText("Reset cycle counter");
        this._resetCounterButton.addActionListener(new ResetCycleCounter());
        this._resetCounterButton.setText("0");
        this.add(this._resetCounterButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)this._editCounter, "Center");
        panel.add((Component)this._resetCounterButton, "East");
        this.add(panel);
        this.addSeparator();
        this._defaultTextColor = this._editProgramCounter.getForeground();
    }

    private JTextField createBlock(String title, String init, String tooltip) {
        JLabel label = new JLabel(title);
        JTextField edit = new JTextField(init);
        edit.setFont(this._textFont);
        if (tooltip != null) {
            edit.setToolTipText(tooltip);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)edit, "Center");
        this.add(panel);
        return edit;
    }

    public void updateValues(boolean runningState) {
        if (runningState) {
            this.updateText(this._editProgramCounter, "????", false, false);
            this.updateText(this._editAccu, "??", false, false);
            this.updateText(this._editX, "??", false, false);
            this.updateText(this._editY, "??", false, false);
            this.updateText(this._editFlags, "????????", false, false);
            this.updateText(this._editStackPointer, "??", false, false);
            this.updateText(this._editTicks, "???????", false, false);
            this.updateText(this._editCounter, "???????", false, false);
            this._resetCounterButton.setEnabled(false);
        } else {
            int pc = this._cpu.getPC();
            int accu = (int)this._cpu.getAccu().getNumber();
            int x = (int)this._cpu.getX().getNumber();
            int y = (int)this._cpu.getY().getNumber();
            int flags = (int)this._cpu.getFlags().getNumber();
            int sp = (int)this._cpu.getSP().getNumber();
            this.updateText(this._editProgramCounter, "$" + new HwWord((long)this._cpu.getPC()).toString(), true, pc != this._lastPc);
            this.updateText(this._editAccu, "$" + this._cpu.getAccu().toString(), true, accu != this._lastAccu);
            this.updateText(this._editX, "$" + this._cpu.getX().toString(), true, x != this._lastX);
            this.updateText(this._editY, "$" + this._cpu.getY().toString(), true, y != this._lastY);
            this.updateText(this._editFlags, this._cpu.getFlags().toFlagString(), true, flags != this._lastFlags);
            this.updateText(this._editStackPointer, "$" + this._cpu.getSP().toString(), true, sp != this._lastSp);
            this.updateText(this._editTicks, "" + this._cpu.getTicks(), true, false);
            this.updateText(this._editCounter, "" + (this._cpu.getTicks() - this._currentCounterOffset), true, false);
            this._lastPc = pc;
            this._lastAccu = accu;
            this._lastX = x;
            this._lastY = y;
            this._lastFlags = flags;
            this._lastSp = sp;
            this._resetCounterButton.setEnabled(true);
        }
    }

    public void transferValuesToCPU() {
        if (!this._cpu.isRunning()) {
            this._lastPc = this.retrieveNumber(this._editProgramCounter);
            if (this._lastPc >= 0) {
                this._cpu.setPC(this._lastPc);
            } else {
                this._lastPc = this._cpu.getPC();
            }
            this._lastAccu = this.retrieveNumber(this._editAccu);
            if (this._lastAccu >= 0) {
                this._cpu.setAccu(new HwByte((long)this._lastAccu));
            } else {
                this._lastAccu = (int)this._cpu.getAccu().getNumber();
            }
            this._lastX = this.retrieveNumber(this._editX);
            if (this._lastX >= 0) {
                this._cpu.setX(new HwByte((long)this._lastX));
            } else {
                this._lastX = (int)this._cpu.getX().getNumber();
            }
            this._lastY = this.retrieveNumber(this._editY);
            if (this._lastY >= 0) {
                this._cpu.setY(new HwByte((long)this._lastY));
            } else {
                this._lastY = (int)this._cpu.getY().getNumber();
            }
            Flags6502 flags = new Flags6502();
            flags.fromFlagString(this._editFlags.getText());
            this._lastFlags = (int)flags.getNumber();
            this._cpu.setFlags(flags);
            this._lastSp = this.retrieveNumber(this._editStackPointer);
            if (this._lastSp >= 0) {
                this._cpu.setSP(new HwByte((long)this._lastSp));
            } else {
                this._lastSp = (int)this._cpu.getSP().getNumber();
            }
        }
    }

    private void updateText(JTextField edit, String text, boolean is_editable, boolean has_changed) {
        edit.setText(text);
        edit.setEditable(is_editable);
        edit.setForeground(has_changed ? Color.red : this._defaultTextColor);
    }

    private int retrieveNumber(JTextField edit) {
        String number_text = edit.getText();
        int number = -1;
        try {
            number = AddressRange.addressFromString(number_text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    public class ResetCycleCounter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            CpuRegisterPanel.this._currentCounterOffset = CpuRegisterPanel.this._cpu.getTicks();
            CpuRegisterPanel.this._editCounter.setText("0");
        }
    }
}

